﻿IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.[CPJ_Copiar_Producto]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.[CPJ_Copiar_Producto]
END
GO 

CREATE PROCEDURE [dbo].[CPJ_Copiar_Producto]   @pJson VARCHAR(8000)
AS 
SET NOCOUNT ON 

/*Variables recibidas por parametro a traves del JSON*/
DECLARE @pFlagUsarTrans			TINYINT
DECLARE @pModoDebug				TINYINT
DECLARE @pId_Producto			VARCHAR(14)
DECLARE @pCodigo_Nuevo			VARCHAR(14)
DECLARE @pDescripcion			VARCHAR(150)
DECLARE @pPrecios_Inic			TINYINT


SET @pFlagUsarTrans			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pPrecios_Inic			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Precios_Inic')), 0)
SET @pId_Producto			= ISNULL(CONVERT(VARCHAR(14), dbo.CF_JSON_VALUE(@pJson,'Id_Producto')), '')
SET @pCodigo_Nuevo			= ISNULL(CONVERT(VARCHAR(14), dbo.CF_JSON_VALUE(@pJson,'New_Id')), '')
SET @pDescripcion			= ISNULL(CONVERT(VARCHAR(150), dbo.CF_JSON_VALUE(@pJson,'New_Descrip')), '')
/*FIN Variables recibidas por parametro a traves del JSON*/
	
Select * into #NewProd From Productos  Where id_Producto = @pId_Producto

Select * into #Listas_Precios From Prod_Listas_Precios_Items Where id_Producto = @pId_Producto

Select * into #Prod_Comp From Productos_Comp Where id_Producto = @pId_Producto

IF @pPrecios_Inic = 1
   BEGIN
		Update #NewProd Set Id_Producto = @pCodigo_Nuevo, Descripcion_Detallada = @pDescripcion
			   , Descripcion_Resumida = @pDescripcion, Tipo = 'M', Activo = 1, Fecha_Alta = Getdate()
			   ,Precio_Exento = 0,Precio_Final = 0,Costo = 0,Fecha_Costo = null

		Update #Listas_Precios Set Id_Producto = @pCodigo_Nuevo, Precio = 0, Precio_Nuevo = 0, Fecha_Desde = Null, Fecha_Hasta = Null
   END
 ELSE
   BEGIN
		Update #NewProd Set Id_Producto = @pCodigo_Nuevo, Descripcion_Detallada = @pDescripcion
			   , Descripcion_Resumida = @pDescripcion, Activo = 1, Fecha_Alta = Getdate()

		Update #Listas_Precios Set Id_Producto = @pCodigo_Nuevo
   END

Update #Prod_Comp Set Id_Producto = @pCodigo_Nuevo

INSERT INTO Productos   SELECT * FROM #NewProd

INSERT INTO Prod_Listas_Precios_Items   SELECT * FROM #Listas_Precios

INSERT INTO Productos_Comp   SELECT * FROM #Prod_Comp

DROP TABLE #NewProd
DROP TABLE #Prod_Comp
DROP TABLE #Listas_Precios

RETURN 0 


/*
---- SELECT * FROM PRODUCTOS ORDER BY ID_PRODUCTO DESC
 

--  DELETE Prod_Listas_Precios_Items WHERE Id_Producto IN ('71620','71620')
    DELETE PRODUCTOS WHERE Id_Producto IN ('71620','71620')


CPJ_Copiar_Producto '{"FlagUsarTrans":"0"
									,"ModoDebug":"0"
									,"Id_Producto":"63829"
									,"New_Id":"71619"
									,"New_Descrip":"VIC PRUEBA /copia"}'

xsys-release 20231021v-CPJ_Copiar_Producto.sql
*/